//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Verify Signature
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
unsigned char key[1024],tbs[2048],sig[1024];
//------------------------------------------------------------------------------
void inv_copy(unsigned char *dest, const unsigned char *src, int n) {
 int i;
 unsigned char c;
 if (dest!=src) for(i=0;i<n;i++) dest[i]=src[n-i-1];
 else for(i=0;i<n/2;i++) {c=dest[i]; dest[i]=src[n-i-1]; dest[n-i-1]=c;}
}
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTHASH hHash;
 HCRYPTKEY  hKey;
 DWORD szk,szs,szt;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //  key
 if (getFileLen("key.bin",   &szk)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  ("key.bin",key,szk)) {printf("readFile error\r\n");   return 1;}
 //  sig
 if (getFileLen("sig.bin",   &szs)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  ("sig.bin",sig,szs)) {printf("readFile error\r\n");   return 1;}
 //  tbs
 if (getFileLen("tbs.bin",   &szt)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  ("tbs.bin",tbs,szt)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,NULL,CRYPT_VERIFYCONTEXT,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //  -
 if (!CPCreateHash(hProv,CALG_SHA_160,0,0,&hHash)) {
   printf("CPCreateHash Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 if (!CPHashData(hProv,hHash,tbs,szt,0)) {
   printf("CPHashData Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //     
 if (!CPImportKey(hProv,key,szk,0,0,&hKey)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }

 inv_copy(sig,sig,(int)szs);

 //  
 if (!CPVerifySignature(hProv,hHash,sig,szs,hKey,NULL,0)) {
   printf("CPVerifySignature Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //
 CPDestroyHash(hProv,hHash);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
